/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.annotation.handler;

import cn.dev33.satoken.annotation.SaCheckDisable;
import cn.dev33.satoken.annotation.SaCheckHttpBasic;
import cn.dev33.satoken.annotation.SaCheckHttpDigest;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckOr;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.annotation.handler.SaAnnotationHandlerInterface;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.strategy.SaAnnotationStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class SaCheckOrHandler
implements SaAnnotationHandlerInterface<SaCheckOr> {
    @Override
    public Class<SaCheckOr> getHandlerAnnotationClass() {
        return SaCheckOr.class;
    }

    @Override
    public void checkMethod(SaCheckOr at, Method method) {
        SaCheckOrHandler._checkMethod(at.login(), at.role(), at.permission(), at.safe(), at.httpBasic(), at.httpDigest(), at.disable(), method);
    }

    public static void _checkMethod(SaCheckLogin[] login, SaCheckRole[] role, SaCheckPermission[] permission, SaCheckSafe[] safe, SaCheckHttpBasic[] httpBasic, SaCheckHttpDigest[] httpDigest, SaCheckDisable[] disable, Method method) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        annotationList.addAll(Arrays.asList(login));
        annotationList.addAll(Arrays.asList(role));
        annotationList.addAll(Arrays.asList(permission));
        annotationList.addAll(Arrays.asList(safe));
        annotationList.addAll(Arrays.asList(disable));
        annotationList.addAll(Arrays.asList(httpBasic));
        annotationList.addAll(Arrays.asList(httpDigest));
        if (annotationList.isEmpty()) {
            return;
        }
        ArrayList<SaTokenException> errorList = new ArrayList<SaTokenException>();
        for (Annotation item : annotationList) {
            try {
                SaAnnotationStrategy.instance.annotationHandlerMap.get(item.annotationType()).check(item, method);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        throw (SaTokenException)errorList.get(0);
    }
}

