/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.dao.alone;

import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.SaTokenDaoDefaultImpl;
import cn.dev33.satoken.dao.SaTokenDaoRedis;
import cn.dev33.satoken.dao.SaTokenDaoRedisFastjson;
import cn.dev33.satoken.dao.SaTokenDaoRedisFastjson2;
import cn.dev33.satoken.dao.SaTokenDaoRedisJackson;
import cn.dev33.satoken.exception.SaTokenException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSocketConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.RedisStaticMasterReplicaConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;

@Configuration
public class SaAloneRedisInject
implements EnvironmentAware {
    public static final String ALONE_PREFIX = "sa-token.alone-redis";
    @Autowired(required=false)
    public SaTokenDao saTokenDao;

    public void setEnvironment(Environment environment) {
        try {
            List serverList;
            RedisStandaloneConfiguration redisAloneConfig;
            if (this.saTokenDao == null || this.saTokenDao instanceof SaTokenDaoDefaultImpl) {
                return;
            }
            RedisProperties cfg = (RedisProperties)Binder.get((Environment)environment).bind(ALONE_PREFIX, RedisProperties.class).get();
            String pattern = environment.getProperty("sa-token.alone-redis.pattern", "single");
            if (pattern.equals("single")) {
                RedisStandaloneConfiguration redisConfig = new RedisStandaloneConfiguration();
                redisConfig.setHostName(cfg.getHost());
                redisConfig.setPort(cfg.getPort());
                redisConfig.setDatabase(cfg.getDatabase());
                redisConfig.setPassword(RedisPassword.of((String)cfg.getPassword()));
                redisConfig.setDatabase(cfg.getDatabase());
                try {
                    redisConfig.setUsername(cfg.getUsername());
                }
                catch (NoSuchMethodError e) {
                    System.err.println(e.getMessage());
                }
                redisAloneConfig = redisConfig;
            } else if (pattern.equals("cluster")) {
                RedisClusterConfiguration redisClusterConfig = new RedisClusterConfiguration();
                try {
                    redisClusterConfig.setUsername(cfg.getUsername());
                }
                catch (NoSuchMethodError e) {
                    System.err.println(e.getMessage());
                }
                redisClusterConfig.setPassword(RedisPassword.of((String)cfg.getPassword()));
                RedisProperties.Cluster cluster = cfg.getCluster();
                serverList = cluster.getNodes().stream().map(node -> {
                    String[] ipAndPort = node.split(":");
                    return new RedisNode(ipAndPort[0].trim(), Integer.parseInt(ipAndPort[1]));
                }).collect(Collectors.toList());
                redisClusterConfig.setClusterNodes(serverList);
                redisClusterConfig.setMaxRedirects(cluster.getMaxRedirects().intValue());
                redisAloneConfig = redisClusterConfig;
            } else if (pattern.equals("sentinel")) {
                RedisSentinelConfiguration redisSentinelConfiguration = new RedisSentinelConfiguration();
                redisSentinelConfiguration.setDatabase(cfg.getDatabase());
                try {
                    redisSentinelConfiguration.setUsername(cfg.getUsername());
                }
                catch (NoSuchMethodError e) {
                    System.err.println(e.getMessage());
                }
                redisSentinelConfiguration.setPassword(RedisPassword.of((String)cfg.getPassword()));
                RedisProperties.Sentinel sentinel = cfg.getSentinel();
                redisSentinelConfiguration.setMaster(sentinel.getMaster());
                redisSentinelConfiguration.setSentinelPassword(sentinel.getPassword());
                serverList = sentinel.getNodes().stream().map(node -> {
                    String[] ipAndPort = node.split(":");
                    return new RedisNode(ipAndPort[0].trim(), Integer.parseInt(ipAndPort[1]));
                }).collect(Collectors.toList());
                redisSentinelConfiguration.setSentinels(serverList);
                redisAloneConfig = redisSentinelConfiguration;
            } else if (pattern.equals("socket")) {
                RedisSocketConfiguration redisSocketConfiguration = new RedisSocketConfiguration();
                redisSocketConfiguration.setDatabase(cfg.getDatabase());
                try {
                    redisSocketConfiguration.setUsername(cfg.getUsername());
                }
                catch (NoSuchMethodError e) {
                    System.err.println(e.getMessage());
                }
                redisSocketConfiguration.setPassword(RedisPassword.of((String)cfg.getPassword()));
                String socket = environment.getProperty("sa-token.alone-redis.socket", "");
                redisSocketConfiguration.setSocket(socket);
                redisAloneConfig = redisSocketConfiguration;
            } else if (pattern.equals("aws")) {
                String hostName = cfg.getHost();
                int port = cfg.getPort();
                RedisStaticMasterReplicaConfiguration redisStaticMasterReplicaConfiguration = new RedisStaticMasterReplicaConfiguration(hostName, port);
                redisStaticMasterReplicaConfiguration.setDatabase(cfg.getDatabase());
                try {
                    redisStaticMasterReplicaConfiguration.setUsername(cfg.getUsername());
                }
                catch (NoSuchMethodError e) {
                    System.err.println(e.getMessage());
                }
                redisStaticMasterReplicaConfiguration.setPassword(RedisPassword.of((String)cfg.getPassword()));
                redisAloneConfig = redisStaticMasterReplicaConfiguration;
            } else {
                throw new SaTokenException("SaToken \u65e0\u6cd5\u8bc6\u522b Alone-Redis \u914d\u7f6e\u7684\u6a21\u5f0f: " + pattern);
            }
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            RedisProperties.Lettuce lettuce = cfg.getLettuce();
            if (lettuce.getPool() != null) {
                RedisProperties.Pool pool = cfg.getLettuce().getPool();
                poolConfig.setMaxTotal(pool.getMaxActive());
                poolConfig.setMaxIdle(pool.getMaxIdle());
                poolConfig.setMinIdle(pool.getMinIdle());
                poolConfig.setMaxWaitMillis(pool.getMaxWait().toMillis());
            }
            LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder builder = LettucePoolingClientConfiguration.builder();
            if (cfg.getTimeout() != null) {
                builder.commandTimeout(cfg.getTimeout());
            }
            if (lettuce.getShutdownTimeout() != null) {
                builder.shutdownTimeout(lettuce.getShutdownTimeout());
            }
            LettucePoolingClientConfiguration clientConfig = builder.poolConfig(poolConfig).build();
            LettuceConnectionFactory factory = new LettuceConnectionFactory((RedisConfiguration)redisAloneConfig, (LettuceClientConfiguration)clientConfig);
            factory.afterPropertiesSet();
            try {
                Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedis");
                SaTokenDaoRedis dao = (SaTokenDaoRedis)this.saTokenDao;
                dao.isInit = false;
                dao.init((RedisConnectionFactory)factory);
                return;
            }
            catch (ClassNotFoundException dao) {
                try {
                    Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedisJackson");
                    SaTokenDaoRedisJackson dao2 = (SaTokenDaoRedisJackson)this.saTokenDao;
                    dao2.isInit = false;
                    dao2.init((RedisConnectionFactory)factory);
                    return;
                }
                catch (ClassNotFoundException dao2) {
                    try {
                        Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedisFastjson");
                        SaTokenDaoRedisFastjson dao3 = (SaTokenDaoRedisFastjson)this.saTokenDao;
                        dao3.isInit = false;
                        dao3.init((RedisConnectionFactory)factory);
                        return;
                    }
                    catch (ClassNotFoundException dao3) {
                        try {
                            Class.forName("cn.dev33.satoken.dao.SaTokenDaoRedisFastjson2");
                            SaTokenDaoRedisFastjson2 dao4 = (SaTokenDaoRedisFastjson2)this.saTokenDao;
                            dao4.isInit = false;
                            dao4.init((RedisConnectionFactory)factory);
                            return;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ConfigurationProperties(prefix="sa-token.alone-redis")
    public RedisProperties getSaAloneRedisConfig() {
        return new RedisProperties();
    }
}

