/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.fastpath.Fastpath;
import com.kingbase8.fastpath.FastpathArg;
import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class LargeObjectManager {
    private BaseConnection _conn;
    private Fastpath fastPathT;
    public static final int READ = 262144;
    public static final int WRITE = 131072;
    public static final int READWRITE = 393216;

    private LargeObjectManager() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public LargeObjectManager(BaseConnection _conn) throws SQLException {
        String _sql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._conn = _conn;
        this.fastPathT = _conn.getFastpathAPI();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_conn.getMetaData().supportsSchemasInTableDefinitions()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = "SELECT p.proname,p.oid  FROM PG_CATALOG.PG_proc p, PG_CATALOG.PG_namespace n  WHERE p.pronamespace=n.oid AND n.nspname='pg_catalog' AND (";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = "SELECT proname,oid FROM pg_proc WHERE ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" proname = 'lo_open'");
        stringBuilder.append(" or proname = 'lo_close'");
        stringBuilder.append(" or proname = 'lo_creat'");
        stringBuilder.append(" or proname = 'lo_unlink'");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(" or proname = 'lo_lseek'");
        stringBuilder.append(" or proname = 'lo_lseek64'");
        stringBuilder.append(" or proname = 'lo_tell'");
        stringBuilder.append(" or proname = 'lo_tell64'");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stringBuilder.append(" or proname = 'loread'");
        stringBuilder.append(" or proname = 'lowrite'");
        stringBuilder.append(" or proname = 'lo_truncate'");
        stringBuilder.append(" or proname = 'lo_truncate64'");
        _sql = _sql + stringBuilder.toString();
        if (_conn.getMetaData().supportsSchemasInTableDefinitions()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = _sql + ")";
        }
        Statement statement = _conn.createStatement();
        ResultSet resultSet = statement.executeQuery(_sql);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fastPathT.addFunctions(resultSet);
        resultSet.close();
        statement.close();
        KBLOGGER.log(Level.FINE, "Large Object initialised", new Object[0]);
    }

    @Deprecated
    public LargeObject open(int _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open((long)_oid, false);
    }

    public LargeObject open(int _oid, boolean commitOnClose) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open((long)_oid, commitOnClose);
    }

    public LargeObject open(long _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open(_oid, 393216, false);
    }

    public LargeObject open(long _oid, boolean commitOnClose) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open(_oid, 393216, commitOnClose);
    }

    @Deprecated
    public LargeObject open(int _oid, int mode) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open((long)_oid, mode, false);
    }

    public LargeObject open(int _oid, int mode, boolean commitOnClose) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open((long)_oid, mode, commitOnClose);
    }

    public LargeObject open(long _oid, int mode) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.open(_oid, mode, false);
    }

    public LargeObject open(long _oid, int mode, boolean commitOnClose) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._conn.getAutoCommit()) {
            throw new KSQLException(GT.tr("Large Objects may not be used in auto-commit mode.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        return new LargeObject(this.fastPathT, _oid, mode, this._conn, commitOnClose);
    }

    @Deprecated
    public int create() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.create(393216);
    }

    public long createLO() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.createLO(393216);
    }

    public long createLO(int mode) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._conn.getAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Large Objects may not be used in auto-commit mode.", new Object[0]), KSQLState.NO_ACTIVE_SQL_TRANSACTION);
        }
        FastpathArg[] argsT = new FastpathArg[1];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[0] = new FastpathArg(mode);
        return this.fastPathT.getOID("lo_creat", argsT);
    }

    @Deprecated
    public int create(int mode) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long _oid = this.createLO(mode);
        return (int)_oid;
    }

    public void delete(long _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[]{Fastpath.createOIDArg(_oid)};
        this.fastPathT.fp("lo_unlink", argsT);
    }

    @Deprecated
    public void unlink(int _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.delete((long)_oid);
    }

    public void unlink(long _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.delete(_oid);
    }

    @Deprecated
    public void delete(int _oid) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.delete((long)_oid);
    }
}

