/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.fastpath.Fastpath;
import com.kingbase8.fastpath.FastpathArg;
import com.kingbase8.largeobject.BlobInputStream;
import com.kingbase8.largeobject.BlobOutputStream;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;

public class LargeObject {
    private static final boolean TRUE = true;
    public static final int SEEK_END = 2;
    public static final int SEEK_SET = 0;
    public static final int SEEK_CURRENT = 1;
    private boolean commitOnClose;
    private BaseConnection _conn;
    private final Fastpath fastPath;
    private final int modeT;
    private final long _oid;
    private final int fd;
    private boolean isClosed = false;
    private BlobOutputStream blobOutputStream;

    protected LargeObject(Fastpath fastPathT, long _oid, int mode, BaseConnection _conn, boolean commitOnCloseT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.fastPath = fastPathT;
        this._oid = _oid;
        this.modeT = mode;
        if (commitOnCloseT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.commitOnClose = true;
            this._conn = _conn;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.commitOnClose = false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] args = new FastpathArg[]{Fastpath.createOIDArg(_oid), new FastpathArg(mode)};
        this.fd = fastPathT.getInteger("lo_open", args);
    }

    protected LargeObject(Fastpath fastPathT, long _oid, int mode) throws SQLException {
        this(fastPathT, _oid, mode, null, false);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public LargeObject copy() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new LargeObject(this.fastPath, this._oid, this.modeT);
    }

    @Deprecated
    public int getOID() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (int)this._oid;
    }

    public long getLongOID() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._oid;
    }

    public void close() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!this.isClosed) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.blobOutputStream != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.blobOutputStream.flush();
                }
                catch (IOException ioException) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new KSQLException("Exception flushing output stream", KSQLState.DATA_ERROR, (Throwable)ioException);
                }
                finally {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.blobOutputStream = null;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            FastpathArg[] argsT = new FastpathArg[]{new FastpathArg(this.fd)};
            this.fastPath.fp("lo_close", argsT);
            this.isClosed = true;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.commitOnClose) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._conn.commit();
            }
        }
    }

    public byte[] read(int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[]{new FastpathArg(this.fd), new FastpathArg(leng)};
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fastPath.getData("loread", argsT);
    }

    public int read(byte[] _buf, int off, int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] bytes = this.read(leng);
        if (bytes.length < leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            leng = bytes.length;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        System.arraycopy(bytes, 0, _buf, off, leng);
        return leng;
    }

    public void write(byte[] _buf) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[2];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(_buf);
        this.fastPath.fp("lowrite", argsT);
    }

    public void write(byte[] _buf, int off, int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[2];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(_buf, off, leng);
        this.fastPath.fp("lowrite", argsT);
    }

    public void seek(int position, int ref) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[3];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(position);
        argsT[2] = new FastpathArg(ref);
        this.fastPath.fp("lo_lseek", argsT);
    }

    public void seek64(long position, int ref) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[3];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(position);
        argsT[2] = new FastpathArg(ref);
        this.fastPath.fp("lo_lseek64", argsT);
    }

    public void seek(int positionT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.seek(positionT, 0);
    }

    public int tell() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fastPath.getInteger("lo_tell", argsT);
    }

    public long tell64() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[]{new FastpathArg(this.fd)};
        return this.fastPath.getLong("lo_tell64", argsT);
    }

    public int size() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int cpT = this.tell();
        this.seek(0, 2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int size = this.tell();
        this.seek(cpT, 0);
        return size;
    }

    public long size64() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long cpT = this.tell64();
        this.seek64(0L, 2);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long size = this.tell64();
        this.seek64(cpT, 0);
        return size;
    }

    public void truncate(int leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[2];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(leng);
        this.fastPath.getInteger("lo_truncate", argsT);
    }

    public void truncate64(long leng) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        FastpathArg[] argsT = new FastpathArg[2];
        argsT[0] = new FastpathArg(this.fd);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        argsT[1] = new FastpathArg(leng);
        this.fastPath.getInteger("lo_truncate64", argsT);
    }

    public InputStream getInputStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new BlobInputStream(this, 4096);
    }

    public InputStream getInputStream(long limitT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new BlobInputStream(this, 4096, limitT);
    }

    public OutputStream getOutputStream() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.blobOutputStream == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.blobOutputStream = new BlobOutputStream(this, 4096);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.blobOutputStream;
    }
}

