/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Version;
import com.kingbase8.util.TraceLogger;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.logging.Level;

public enum ServerVersion implements Version
{
    INVALID("0.0.0"),
    v8_2("8.2.0"),
    v8_3("8.3.0"),
    v8_4("8.4.0"),
    v9_0("9.0.0"),
    v9_1("9.1.0"),
    v9_2("9.2.0"),
    v9_3("9.3.0"),
    v9_4("9.4.0"),
    v9_5("9.5.0"),
    v9_6("9.6.0"),
    v10("10"),
    v11("11"),
    v12("12");

    private final int _version;

    private ServerVersion(String _version) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._version = ServerVersion.parseServerVersionStr(_version);
    }

    @Override
    public int getVersionNum() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._version;
    }

    public static Version from(String versionT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        final int versionNumT = ServerVersion.parseServerVersionStr(versionT);
        return new Version(){

            @Override
            public int getVersionNum() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return versionNumT;
            }

            public boolean equals(Object object) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (object instanceof Version) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return ((Version)object).getVersionNum() == this.getVersionNum();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }

            public String toString() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return Integer.toString(versionNumT);
            }

            public int hashCode() {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return this.getVersionNum();
            }
        };
    }

    static int parseServerVersionStr(String serVersion) throws NumberFormatException {
        int _versionParts;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        NumberFormat numformat = NumberFormat.getIntegerInstance();
        numformat.setGroupingUsed(false);
        ParsePosition parseposition = new ParsePosition(0);
        if (serVersion == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return 0;
        }
        int[] parts = new int[3];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (_versionParts = 0; _versionParts < 3; ++_versionParts) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Number part = (Number)numformat.parseObject(serVersion, parseposition);
            if (part == null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                break;
            }
            parts[_versionParts] = part.intValue();
            if (parseposition.getIndex() == serVersion.length() || serVersion.charAt(parseposition.getIndex()) != '.') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                break;
            }
            parseposition.setIndex(parseposition.getIndex() + 1);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ++_versionParts;
        if (parts[0] >= 10000) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (parseposition.getIndex() == serVersion.length() && _versionParts == 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return parts[0];
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException("First major-_version part equal to or greater than 10000 in invalid _version string: " + serVersion);
        }
        if (_versionParts >= 3) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (parts[1] > 99) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Unsupported second part of major _version > 99 in invalid _version string: " + serVersion);
            }
            if (parts[2] > 99) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Unsupported second part of minor _version > 99 in invalid _version string: " + serVersion);
            }
            return (parts[0] * 100 + parts[1]) * 100 + parts[2];
        }
        if (_versionParts == 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (parts[0] >= 10) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return parts[0] * 100 * 100 + parts[1];
            }
            if (parts[1] > 99) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new NumberFormatException("Unsupported second part of major _version > 99 in invalid _version string: " + serVersion);
            }
            return (parts[0] * 100 + parts[1]) * 100;
        }
        if (_versionParts == 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (parts[0] >= 10) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return parts[0] * 100 * 100;
            }
        }
        return 0;
    }
}

