/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.TraceLogger;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostSpec {
    public static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*|[::1]|0.0.0.0|[::0]";
    protected final String _host;
    protected final int port;

    public HostSpec(String _host, int port) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._host = _host;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.port = port;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public String getHost() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._host;
    }

    public int getPort() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.port;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._host + ":" + this.port;
    }

    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return objt instanceof HostSpec && this.port == ((HostSpec)objt).port && this._host.equals(((HostSpec)objt)._host);
    }

    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.port ^ this._host.hashCode();
    }

    public Boolean shouldResolve() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String socksProxyHost = System.getProperty("socksProxyHost");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (socksProxyHost == null || socksProxyHost.trim().isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.matchesNonProxyHosts();
    }

    private Boolean matchesNonProxyHosts() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String nonProxyHosts = System.getProperty("socksNonProxyHosts", DEFAULT_NON_PROXY_HOSTS);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (nonProxyHosts == null || this._host.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Pattern pat = this.toPattern(nonProxyHosts);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Matcher matcher = pat == null ? null : pat.matcher(this._host);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return matcher != null && matcher.matches();
    }

    private Pattern toPattern(String str) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder joiner = new StringBuilder();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String separator = "";
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (String disjunct : str.split("\\|")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (disjunct.isEmpty()) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String reg = this.disjunctToRegex(disjunct.toLowerCase());
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            joiner.append(separator).append(reg);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            separator = "|";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return joiner.length() == 0 ? null : Pattern.compile(joiner.toString());
    }

    private String disjunctToRegex(String disjunct) {
        String reg;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (disjunct.startsWith("*")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reg = ".*" + Pattern.quote(disjunct.substring(1));
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        } else if (disjunct.endsWith("*")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reg = Pattern.quote(disjunct.substring(0, disjunct.length() - 1)) + ".*";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            reg = Pattern.quote(disjunct);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return reg;
    }
}

