/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jre7.sasl;

import com.kingbase8.core.KBStream;
import com.kingbase8.shaded.com.ongres.scram.client.ScramClient;
import com.kingbase8.shaded.com.ongres.scram.client.ScramSession;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramInvalidServerSignatureException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramParseException;
import com.kingbase8.shaded.com.ongres.scram.common.exception.ScramServerErrorException;
import com.kingbase8.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import com.kingbase8.util.BouncyCastleUtils;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;

public class ScramAuthenticator {
    private final String userT;
    private final String passwordT;
    private final KBStream kbStream;
    private ScramSession.ClientFinalProcessor clientFinalProcessorT;
    private ScramSession.ServerFirstProcessor serverFirstProcessorT;
    private ScramSession scramSessionT;
    private ScramClient scramClientT;

    private void sendAuthenticationMessage(int bodyLength, BodySender bodySender) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStream.sendChar(112);
        this.kbStream.sendInteger4(4 + bodyLength);
        bodySender.sendBody(this.kbStream);
        this.kbStream.flush();
    }

    public ScramAuthenticator(String user, String password, KBStream kbStream) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.userT = user;
        this.passwordT = password;
        this.kbStream = kbStream;
    }

    public void processServerMechanismsAndInit() throws IOException, KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<String> mechanismsT = new ArrayList<String>();
        do {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String mechanisms = this.kbStream.receiveString();
            if (mechanisms.toUpperCase().indexOf("SM3") > -1) {
                BouncyCastleUtils.initBouncyCastleProvider();
            }
            if (!("SCRAM-SHA-256".equalsIgnoreCase(mechanisms) || "SCRAM-SHA-256-PLUS".equalsIgnoreCase(mechanisms) || "SCRAM-SM3".equalsIgnoreCase(mechanisms) || "SCRAM-SHA-1".equalsIgnoreCase(mechanisms) || "SCRAM-SHA-1-PLUS".equalsIgnoreCase(mechanisms))) {
                throw new KSQLException(GT.tr("SCRAM mechanism is not supported,supported mechanism are SCRAM-SHA-256,SCRAM-SHA-256-PLUS,SCRAM-SM3,SCRAM-SHA-1-PLUS and SCRAM-SHA-1. this mechanisms=" + mechanisms, new Object[0]), KSQLState.CONNECTION_REJECTED);
            }
            mechanismsT.add(mechanisms);
        } while (this.kbStream.peekChar() != 0);
        int c = this.kbStream.receiveChar();
        assert (c == 0);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (mechanismsT.size() < 1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("No SCRAM mechanism(s) advertised by the server", new Object[0]), KSQLState.CONNECTION_REJECTED);
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.scramClientT = ScramClient.channelBinding(ScramClient.ChannelBinding.NO).stringPreparation(StringPreparations.SASL_PREPARATION).selectMechanismBasedOnServerAdvertised(mechanismsT.toArray(new String[0])).setup();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid or unsupported by client SCRAM mechanisms", illegalArgumentException), KSQLState.CONNECTION_REJECTED);
        }
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " Using SCRAM mechanism-- {0}", this.scramClientT.getScramMechanism().getName());
        }
        this.scramSessionT = this.scramClientT.scramSession("*");
    }

    public void sendScramClientFirstMessage() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String clientFirstMsg = this.scramSessionT.clientFirstMessage();
        KBLOGGER.log(Level.FINEST, " FE=> SASLInitialResponse( {0} )", clientFirstMsg);
        String scramMechanismNameT = this.scramClientT.getScramMechanism().getName();
        final byte[] scramMechanismNameBytesT = scramMechanismNameT.getBytes(StandardCharsets.UTF_8);
        final byte[] clientFirstMessageBytesT = clientFirstMsg.getBytes(StandardCharsets.UTF_8);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.sendAuthenticationMessage(scramMechanismNameBytesT.length + 1 + 4 + clientFirstMessageBytesT.length, new BodySender(){

            @Override
            public void sendBody(KBStream kbStream) throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                kbStream.send(scramMechanismNameBytesT);
                kbStream.sendChar(0);
                kbStream.sendInteger4(clientFirstMessageBytesT.length);
                kbStream.send(clientFirstMessageBytesT);
            }
        });
    }

    public void processServerFirstMessage(int length) throws IOException, KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String serverFirstMsg = this.kbStream.receiveString(length);
        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue( {0} )", serverFirstMsg);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.serverFirstProcessorT = this.scramSessionT.receiveServerFirstMessage(serverFirstMsg);
        }
        catch (ScramException scramException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid server-first-message: {0}", serverFirstMsg), KSQLState.CONNECTION_REJECTED, (Throwable)scramException);
        }
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBLOGGER.log(Level.FINEST, " <=BE AuthenticationSASLContinue(salt={0}, iterations={1})", this.serverFirstProcessorT.getSalt(), this.serverFirstProcessorT.getIteration());
        }
        this.clientFinalProcessorT = this.serverFirstProcessorT.clientFinalProcessor(this.passwordT);
        String clientFinalMsg = this.clientFinalProcessorT.clientFinalMessage();
        KBLOGGER.log(Level.FINEST, " FE=> SASLResponse( {0} )", clientFinalMsg);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        final byte[] clientFinalMessageBytesT = clientFinalMsg.getBytes(StandardCharsets.UTF_8);
        this.sendAuthenticationMessage(clientFinalMessageBytesT.length, new BodySender(){

            @Override
            public void sendBody(KBStream kbStream) throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                kbStream.send(clientFinalMessageBytesT);
            }
        });
    }

    public void verifyServerSignature(int length) throws IOException, KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String serverFinalMsg = this.kbStream.receiveString(length);
        KBLOGGER.log(Level.FINEST, " <=BE AuthenticationSASLFinal( {0} )", serverFinalMsg);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.clientFinalProcessorT.receiveServerFinalMessage(serverFinalMsg);
        }
        catch (ScramParseException scramParseException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid server-final-message: {0}", serverFinalMsg), KSQLState.CONNECTION_REJECTED, (Throwable)scramParseException);
        }
        catch (ScramServerErrorException scramServerErrorException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("SCRAM authentication failed, server returned _error: {0}", scramServerErrorException.getError().getErrorMessage()), KSQLState.CONNECTION_REJECTED, (Throwable)scramServerErrorException);
        }
        catch (ScramInvalidServerSignatureException scramInvalidServerSignatureException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Invalid server SCRAM signature", new Object[0]), KSQLState.CONNECTION_REJECTED, (Throwable)scramInvalidServerSignatureException);
        }
    }

    private static interface BodySender {
        public void sendBody(KBStream var1) throws IOException;
    }
}

