/*
 * Copyright 2014-2014 Chen Lichao
 *
 * Licensed to the Apache  Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.chenlichao.wmi4j;

import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JIRuntimeException;

/**
 * WMI exception
 * Created by chenlichao on 14-7-17.
 */
public class WMIException extends JIException {

    public WMIException(JIException jie) {
        super(jie.getErrorCode(), jie.getMessage(), jie.getCause());
    }

    public WMIException(int errorCode, String message) {
        super(errorCode, message);
    }

    public WMIException(int errorCode) {
        super(errorCode);
    }

    public WMIException(int errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    public WMIException(JIRuntimeException exception) {
        super(exception);
    }

    public WMIException(int errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }
}
