/*
 * Decompiled with CFR 0.152.
 */
package com.zhipu.oapi.core.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.zhipu.oapi.core.ConfigV4;
import com.zhipu.oapi.core.cache.ICache;
import com.zhipu.oapi.utils.StringUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManagerV4 {
    private static final Logger logger = LoggerFactory.getLogger(TokenManagerV4.class);
    private ICache cache;
    private static final String tokenV4KeyPrefix = "zhipu_oapi_token_v4";
    private static final Long DELAY_EXPIRE_TIME = 300000L;

    public TokenManagerV4(ICache cache) {
        this.cache = cache;
    }

    public String getToken(ConfigV4 config) {
        String tokenCacheKey = this.genTokenCacheKey(config.getApiKey());
        String cacheToken = this.cache.get(tokenCacheKey);
        if (StringUtils.isNotEmpty(cacheToken)) {
            return cacheToken;
        }
        String newToken = TokenManagerV4.createJwt(config);
        this.cache.set(tokenCacheKey, newToken, config.getExpireMillis(), TimeUnit.MILLISECONDS);
        return newToken;
    }

    private static String createJwt(ConfigV4 config) {
        Algorithm alg;
        String algId = config.getAlg();
        if ("HS256".equals(algId)) {
            try {
                alg = Algorithm.HMAC256((byte[])config.getApiSecret().getBytes("utf-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            logger.error("algorithm: %s not supported", (Object)algId);
            return null;
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("api_key", config.getApiKey());
        payload.put("exp", System.currentTimeMillis() + (long)config.getExpireMillis() + DELAY_EXPIRE_TIME);
        payload.put("timestamp", Calendar.getInstance().getTimeInMillis());
        HashMap<String, String> headerClaims = new HashMap<String, String>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("sign_type", "SIGN");
        String token = JWT.create().withPayload(payload).withHeader(headerClaims).sign(alg);
        return token;
    }

    private String genTokenCacheKey(String apiKey) {
        return String.format("%s-%s", tokenV4KeyPrefix, apiKey);
    }
}

