/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.support.LettuceFactoryBeanSupport;
import java.net.URI;

public class RedisClusterClientFactoryBean
extends LettuceFactoryBeanSupport<RedisClusterClient> {
    private boolean verifyPeer = false;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getRedisURI() == null) {
            URI uri = this.getUri();
            LettuceAssert.isTrue(!uri.getScheme().equals("redis-sentinel"), "Sentinel mode not supported when using RedisClusterClient");
            RedisURI redisURI = RedisURI.create(uri);
            if (LettuceStrings.isNotEmpty(this.getPassword())) {
                redisURI.setPassword(this.getPassword());
            }
            if ("rediss".equals(uri.getScheme()) || "redis+ssl".equals(uri.getScheme()) || "redis+tls".equals(uri.getScheme())) {
                redisURI.setVerifyPeer(this.verifyPeer);
            }
            this.setRedisURI(redisURI);
        }
        super.afterPropertiesSet();
    }

    protected void destroyInstance(RedisClusterClient instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return RedisClusterClient.class;
    }

    protected RedisClusterClient createInstance() throws Exception {
        if (this.getClientResources() != null) {
            return RedisClusterClient.create(this.getClientResources(), this.getRedisURI());
        }
        return RedisClusterClient.create(this.getRedisURI());
    }

    public boolean isVerifyPeer() {
        return this.verifyPeer;
    }

    public void setVerifyPeer(boolean verifyPeer) {
        this.verifyPeer = verifyPeer;
    }
}

