/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ListSubscriber;
import com.lambdaworks.redis.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StringListOutput<K, V>
extends CommandOutput<K, V, List<String>>
implements StreamingOutput<String> {
    private StreamingOutput.Subscriber<String> subscriber;

    public StringListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<String>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext(bytes == null ? null : this.decodeAscii(bytes));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<String> subscriber) {
        LettuceAssert.notNull(subscriber, "subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<String> getSubscriber() {
        return this.subscriber;
    }
}

