/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.GeoCoordinates;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.ListSubscriber;
import com.lambdaworks.redis.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GeoCoordinatesListOutput<K, V>
extends CommandOutput<K, V, List<GeoCoordinates>>
implements StreamingOutput<GeoCoordinates> {
    private Double x;
    private StreamingOutput.Subscriber<GeoCoordinates> subscriber;

    public GeoCoordinatesListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<GeoCoordinates>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        Double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        if (this.x == null) {
            this.x = value;
            return;
        }
        this.subscriber.onNext(new GeoCoordinates(this.x, value));
        this.x = null;
    }

    @Override
    public void multi(int count) {
        if (count == -1) {
            this.subscriber.onNext(null);
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<GeoCoordinates> subscriber) {
        LettuceAssert.notNull(subscriber, "subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<GeoCoordinates> getSubscriber() {
        return this.subscriber;
    }
}

