/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.internal.LettuceAssert;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class LettuceSets {
    private LettuceSets() {
    }

    public static <E> Set<E> newHashSet(Collection<? extends E> elements) {
        LettuceAssert.notNull(elements, "Collection must not be null");
        HashSet<E> set = new HashSet<E>(elements.size());
        set.addAll(elements);
        return set;
    }

    public static <E> Set<E> newHashSet(Iterable<? extends E> elements) {
        LettuceAssert.notNull(elements, "Iterable must not be null");
        if (elements instanceof Collection) {
            return LettuceSets.newHashSet((Collection)elements);
        }
        HashSet<E> set = new HashSet<E>();
        for (E e : elements) {
            set.add(e);
        }
        return set;
    }

    public static <E> Set<E> newHashSet(E ... elements) {
        LettuceAssert.notNull(elements, "Elements must not be null");
        HashSet<E> set = new HashSet<E>(elements.length);
        for (E element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <K> Set<K> unmodifiableSet(K ... elements) {
        return Collections.unmodifiableSet(LettuceSets.newHashSet(elements));
    }
}

