/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

class PartitionAccessor {
    private final Collection<RedisClusterNode> partitions;

    PartitionAccessor(Collection<RedisClusterNode> partitions) {
        this.partitions = partitions;
    }

    List<RedisClusterNode> getMasters() {
        return this.get(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    List<RedisClusterNode> getSlaves() {
        return this.get(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    List<RedisClusterNode> getSlaves(RedisClusterNode master) {
        return this.get(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE) && master.getNodeId().equals(redisClusterNode.getSlaveOf()));
    }

    List<RedisClusterNode> getReadCandidates(RedisClusterNode master) {
        return this.get(redisClusterNode -> redisClusterNode.getNodeId().equals(master.getNodeId()) || redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE) && master.getNodeId().equals(redisClusterNode.getSlaveOf()));
    }

    List<RedisClusterNode> get(Predicate<RedisClusterNode> test) {
        ArrayList<RedisClusterNode> result = new ArrayList<RedisClusterNode>(this.partitions.size());
        for (RedisClusterNode partition : this.partitions) {
            if (!test.test(partition)) continue;
            result.add(partition);
        }
        return result;
    }
}

