/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lambdaworks.redis.RedisCommandExecutionException;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisCommandTimeoutException;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AbstractNodeSelection;
import com.lambdaworks.redis.cluster.AsyncExecutionsImpl;
import com.lambdaworks.redis.cluster.SyncExecutionsImpl;
import com.lambdaworks.redis.cluster.api.NodeSelectionSupport;
import com.lambdaworks.redis.cluster.api.async.RedisClusterAsyncCommands;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

class NodeSelectionInvocationHandler
extends AbstractInvocationHandler {
    private AbstractNodeSelection<?, ?, ?, ?> selection;
    private boolean sync;
    private long timeout;
    private TimeUnit unit;
    private Cache<Method, Method> nodeSelectionMethods = CacheBuilder.newBuilder().build();
    private Cache<Method, Method> connectionMethod = CacheBuilder.newBuilder().build();
    public static final Method NULL_MARKER_METHOD;

    public NodeSelectionInvocationHandler(AbstractNodeSelection<?, ?, ?, ?> selection) {
        this(selection, false, 0L, null);
    }

    public NodeSelectionInvocationHandler(AbstractNodeSelection<?, ?, ?, ?> selection, boolean sync, long timeout, TimeUnit unit) {
        if (sync) {
            LettuceAssert.isTrue(timeout > 0L, "timeout must be greater 0 when using sync mode");
            LettuceAssert.notNull((Object)unit, "unit must not be null when using sync mode");
        }
        this.selection = selection;
        this.sync = sync;
        this.unit = unit;
        this.timeout = timeout;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Method targetMethod = this.findMethod(RedisClusterAsyncCommands.class, method, this.connectionMethod);
            HashMap connections = new HashMap(this.selection.size(), 1.0f);
            connections.putAll(this.selection.statefulMap());
            if (targetMethod != null) {
                HashMap executions = new HashMap();
                for (Map.Entry entry : connections.entrySet()) {
                    CompletionStage result = (CompletionStage)targetMethod.invoke(((StatefulRedisConnection)entry.getValue()).async(), args);
                    executions.put((RedisClusterNode)entry.getKey(), result);
                }
                if (this.sync) {
                    if (!NodeSelectionInvocationHandler.awaitAll(this.timeout, this.unit, executions.values())) {
                        throw this.createTimeoutException(executions);
                    }
                    if (this.atLeastOneFailed(executions)) {
                        throw this.createExecutionException(executions);
                    }
                    return new SyncExecutionsImpl(executions);
                }
                return new AsyncExecutionsImpl(executions);
            }
            if (method.getName().equals("commands") && args.length == 0) {
                return proxy;
            }
            targetMethod = this.findMethod(NodeSelectionSupport.class, method, this.nodeSelectionMethods);
            return targetMethod.invoke(this.selection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static boolean awaitAll(long timeout, TimeUnit unit, Collection<CompletionStage<?>> futures) {
        boolean complete;
        try {
            long nanos = unit.toNanos(timeout);
            long time = System.nanoTime();
            for (CompletionStage<?> f : futures) {
                if (nanos < 0L) {
                    return false;
                }
                try {
                    f.toCompletableFuture().get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                long now = System.nanoTime();
                nanos -= now - time;
                time = now;
            }
            complete = true;
        }
        catch (TimeoutException e) {
            complete = false;
        }
        catch (Exception e) {
            throw new RedisCommandInterruptedException(e);
        }
        return complete;
    }

    private boolean atLeastOneFailed(Map<RedisClusterNode, CompletionStage<?>> executions) {
        return executions.values().stream().filter(completionStage -> completionStage.toCompletableFuture().isCompletedExceptionally()).findFirst().isPresent();
    }

    private RedisCommandTimeoutException createTimeoutException(Map<RedisClusterNode, CompletionStage<?>> executions) {
        ArrayList<RedisClusterNode> notFinished = new ArrayList<RedisClusterNode>();
        executions.forEach((redisClusterNode, completionStage) -> {
            if (!completionStage.toCompletableFuture().isDone()) {
                notFinished.add((RedisClusterNode)redisClusterNode);
            }
        });
        String description = this.getNodeDescription(notFinished);
        return new RedisCommandTimeoutException("Command timed out for node(s): " + description);
    }

    private RedisCommandExecutionException createExecutionException(Map<RedisClusterNode, CompletionStage<?>> executions) {
        ArrayList<RedisClusterNode> failed = new ArrayList<RedisClusterNode>();
        executions.forEach((redisClusterNode, completionStage) -> {
            if (!completionStage.toCompletableFuture().isCompletedExceptionally()) {
                failed.add((RedisClusterNode)redisClusterNode);
            }
        });
        RedisCommandExecutionException e = new RedisCommandExecutionException("Multi-node command execution failed on node(s): " + this.getNodeDescription(failed));
        executions.forEach((redisClusterNode, completionStage) -> {
            CompletableFuture completableFuture = completionStage.toCompletableFuture();
            if (completableFuture.isCompletedExceptionally()) {
                try {
                    completableFuture.get();
                }
                catch (Exception innerException) {
                    if (innerException instanceof ExecutionException) {
                        e.addSuppressed(innerException.getCause());
                    }
                    e.addSuppressed(innerException);
                }
            }
        });
        return e;
    }

    private String getNodeDescription(List<RedisClusterNode> notFinished) {
        return String.join((CharSequence)", ", notFinished.stream().map(redisClusterNode -> this.getDescriptor((RedisClusterNode)redisClusterNode)).collect(Collectors.toList()));
    }

    private String getDescriptor(RedisClusterNode redisClusterNode) {
        StringBuffer buffer = new StringBuffer(redisClusterNode.getNodeId());
        buffer.append(" (");
        if (redisClusterNode.getUri() != null) {
            buffer.append(redisClusterNode.getUri().getHost()).append(':').append(redisClusterNode.getUri().getPort());
        }
        buffer.append(')');
        return buffer.toString();
    }

    private Method findMethod(Class<?> type, Method method, Cache<Method, Method> cache) {
        Method result = (Method)cache.getIfPresent((Object)method);
        if (result != null && result != NULL_MARKER_METHOD) {
            return result;
        }
        for (Method typeMethod : type.getMethods()) {
            if (!typeMethod.getName().equals(method.getName()) || !Arrays.equals(typeMethod.getParameterTypes(), method.getParameterTypes())) continue;
            cache.put((Object)method, (Object)typeMethod);
            return typeMethod;
        }
        cache.put((Object)method, (Object)NULL_MARKER_METHOD);
        return null;
    }

    static {
        try {
            NULL_MARKER_METHOD = NodeSelectionInvocationHandler.class.getDeclaredMethod("handleInvocation", Object.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

