/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.StatefulRedisClusterConnectionImpl;
import com.lambdaworks.redis.cluster.api.NodeSelectionSupport;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

abstract class AbstractNodeSelection<API, CMD, K, V>
implements NodeSelectionSupport<API, CMD> {
    protected StatefulRedisClusterConnection<K, V> globalConnection;
    private ClusterConnectionProvider.Intent intent;
    protected ClusterDistributionChannelWriter<K, V> writer;

    public AbstractNodeSelection(StatefulRedisClusterConnection<K, V> globalConnection, ClusterConnectionProvider.Intent intent) {
        this.globalConnection = globalConnection;
        this.intent = intent;
        this.writer = ((StatefulRedisClusterConnectionImpl)globalConnection).getClusterDistributionChannelWriter();
    }

    protected StatefulRedisConnection<K, V> getConnection(RedisClusterNode redisClusterNode) {
        RedisURI uri = redisClusterNode.getUri();
        return this.writer.getClusterConnectionProvider().getConnection(this.intent, uri.getHost(), uri.getPort());
    }

    protected abstract List<RedisClusterNode> nodes();

    @Override
    public int size() {
        return this.nodes().size();
    }

    public Map<RedisClusterNode, StatefulRedisConnection<K, V>> statefulMap() {
        return this.nodes().stream().collect(Collectors.toMap(redisClusterNode -> redisClusterNode, redisClusterNode1 -> this.getConnection((RedisClusterNode)redisClusterNode1)));
    }

    @Override
    public RedisClusterNode node(int index) {
        return this.nodes().get(index);
    }
}

