/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.tokenizers;

import ai.djl.huggingface.tokenizers.jni.CharSpan;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import java.util.Arrays;

public class Encoding {
    private long[] ids;
    private long[] typeIds;
    private String[] tokens;
    private long[] wordIds;
    private long[] sequenceIds;
    private long[] attentionMask;
    private long[] specialTokenMask;
    private CharSpan[] charTokenSpans;
    private Encoding[] overflowing;
    private boolean exceedMaxLength;

    protected Encoding(long[] ids, long[] typeIds, String[] tokens, long[] wordIds, long[] sequenceIds, long[] attentionMask, long[] specialTokenMask, CharSpan[] charTokenSpans, boolean exceedMaxLength, Encoding[] overflowing) {
        this.ids = ids;
        this.typeIds = typeIds;
        this.tokens = tokens;
        this.wordIds = wordIds;
        this.sequenceIds = sequenceIds;
        this.attentionMask = attentionMask;
        this.specialTokenMask = specialTokenMask;
        this.charTokenSpans = charTokenSpans;
        this.exceedMaxLength = exceedMaxLength;
        this.overflowing = overflowing;
    }

    public static NDList toNDList(Encoding[] encodings, NDManager manager, boolean withTokenType, boolean int32) {
        NDList list = new NDList();
        if (!int32) {
            long[][] ids = new long[encodings.length][];
            long[][] attentionMask = new long[encodings.length][];
            long[][] typeIds = new long[encodings.length][];
            for (int i = 0; i < encodings.length; ++i) {
                ids[i] = encodings[i].getIds();
                attentionMask[i] = encodings[i].getAttentionMask();
                if (!withTokenType) continue;
                typeIds[i] = encodings[i].getTypeIds();
            }
            list.add((Object)manager.create((long[][])ids));
            NDArray inputAttentionMask = manager.create((long[][])attentionMask);
            list.add((Object)inputAttentionMask);
            if (withTokenType) {
                list.add((Object)manager.create((long[][])typeIds));
            }
            return list;
        }
        int[][] ids = new int[encodings.length][];
        int[][] attentionMask = new int[encodings.length][];
        int[][] typeIds = new int[encodings.length][];
        for (int i = 0; i < encodings.length; ++i) {
            ids[i] = Arrays.stream(encodings[i].getIds()).mapToInt(l -> (int)l).toArray();
            attentionMask[i] = Arrays.stream(encodings[i].getAttentionMask()).mapToInt(l -> (int)l).toArray();
            if (!withTokenType) continue;
            typeIds[i] = Arrays.stream(encodings[i].getTypeIds()).mapToInt(l -> (int)l).toArray();
        }
        list.add((Object)manager.create((int[][])ids));
        NDArray inputAttentionMask = manager.create((int[][])attentionMask);
        list.add((Object)inputAttentionMask);
        if (withTokenType) {
            list.add((Object)manager.create((int[][])typeIds));
        }
        return list;
    }

    public NDList toNDList(NDManager manager, boolean withTokenType, boolean int32) {
        NDList list = new NDList(withTokenType ? 3 : 2);
        if (int32) {
            int[] intIds = Arrays.stream(this.ids).mapToInt(i -> (int)i).toArray();
            int[] intAttentionMask = Arrays.stream(this.attentionMask).mapToInt(i -> (int)i).toArray();
            list.add((Object)manager.create(intIds));
            list.add((Object)manager.create(intAttentionMask));
            if (withTokenType) {
                int[] intTypeIds = Arrays.stream(this.typeIds).mapToInt(i -> (int)i).toArray();
                list.add((Object)manager.create(intTypeIds));
            }
        } else {
            list.add((Object)manager.create(this.ids));
            list.add((Object)manager.create(this.attentionMask));
            if (withTokenType) {
                list.add((Object)manager.create(this.typeIds));
            }
        }
        return list;
    }

    public long[] getIds() {
        return this.ids;
    }

    public long[] getTypeIds() {
        return this.typeIds;
    }

    public String[] getTokens() {
        return this.tokens;
    }

    public long[] getWordIds() {
        return this.wordIds;
    }

    public long[] getSequenceIds() {
        return this.sequenceIds;
    }

    public long[] getAttentionMask() {
        return this.attentionMask;
    }

    public long[] getSpecialTokenMask() {
        return this.specialTokenMask;
    }

    public CharSpan[] getCharTokenSpans() {
        return this.charTokenSpans;
    }

    public boolean exceedMaxLength() {
        return this.exceedMaxLength;
    }

    public Encoding[] getOverflowing() {
        return this.overflowing;
    }
}

