/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.nlp;

import ai.djl.Application;
import ai.djl.basicdataset.nlp.TextDataset;
import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Record;
import ai.djl.util.Progress;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class TatoebaEnglishFrenchDataset
extends TextDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "tatoeba-en-fr";

    protected TatoebaEnglishFrenchDataset(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        MRL mrl = MRL.dataset((Application)Application.NLP.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, VERSION);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void prepare(Progress progress) throws IOException, EmbeddingException {
        Path usagePath;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path root = this.resource.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                usagePath = Paths.get("fra-eng-train.txt", new String[0]);
                break;
            }
            case TEST: {
                usagePath = Paths.get("fra-eng-test.txt", new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        usagePath = root.resolve(usagePath);
        ArrayList<String> sourceTextData = new ArrayList<String>();
        ArrayList<String> targetTextData = new ArrayList<String>();
        try (BufferedReader reader = Files.newBufferedReader(usagePath);){
            String row;
            while ((row = reader.readLine()) != null) {
                String[] text = row.split("\t");
                sourceTextData.add(text[0]);
                targetTextData.add(text[1]);
            }
        }
        this.preprocess(sourceTextData, true);
        this.preprocess(targetTextData, false);
        this.prepared = true;
    }

    public Record get(NDManager manager, long index) {
        NDList data = new NDList();
        NDList labels = new NDList();
        data.add((Object)this.sourceTextData.getEmbedding(manager, index));
        labels.add((Object)this.targetTextData.getEmbedding(manager, index));
        return new Record(data, labels);
    }

    protected long availableSize() {
        return this.sourceTextData.getSize();
    }

    public static class Builder
    extends TextDataset.Builder<Builder> {
        public Builder() {
            this.artifactId = TatoebaEnglishFrenchDataset.ARTIFACT_ID;
        }

        public Builder self() {
            return this;
        }

        public TatoebaEnglishFrenchDataset build() {
            return new TatoebaEnglishFrenchDataset(this);
        }
    }
}

