/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.Artifact;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;

public interface ModelZoo {
    public String getGroupId();

    public List<ModelLoader> getModelLoaders();

    default public ModelLoader getModelLoader(String name) {
        for (ModelLoader loader : this.getModelLoaders()) {
            if (!name.equals(loader.getArtifactId())) continue;
            return loader;
        }
        return null;
    }

    public Set<String> getSupportedEngines();

    public static boolean hasModelZoo(String groupId) {
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo zoo = provider.getModelZoo();
            if (!zoo.getGroupId().equals(groupId)) continue;
            return true;
        }
        return false;
    }

    public static <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        return criteria.loadModel();
    }

    public static Map<Application, List<Artifact>> listModels() throws IOException, ModelNotFoundException {
        return ModelZoo.listModels(Criteria.builder().build());
    }

    public static Map<Application, List<Artifact>> listModels(Criteria<?, ?> criteria) throws IOException, ModelNotFoundException {
        String artifactId = criteria.getArtifactId();
        ModelZoo modelZoo = criteria.getModelZoo();
        String groupId = criteria.getGroupId();
        String engine = criteria.getEngine();
        Application application = criteria.getApplication();
        TreeMap<Application, List<Artifact>> models = new TreeMap<Application, List<Artifact>>(Comparator.comparing(Application::getPath));
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo zoo = provider.getModelZoo();
            if (zoo == null) continue;
            if (modelZoo != null) {
                if (groupId != null && !modelZoo.getGroupId().equals(groupId)) continue;
                Set<String> supportedEngine = modelZoo.getSupportedEngines();
                if (engine != null && !supportedEngine.contains(engine)) continue;
            }
            List<ModelLoader> list = zoo.getModelLoaders();
            for (ModelLoader loader : list) {
                Application app = loader.getApplication();
                String loaderArtifactId = loader.getArtifactId();
                if (artifactId != null && !artifactId.equals(loaderArtifactId) || application != Application.UNDEFINED && app != Application.UNDEFINED && !app.matches(application)) continue;
                List<Artifact> artifacts = loader.listModels();
                models.compute(app, (key, val) -> {
                    if (val == null) {
                        val = new ArrayList();
                    }
                    val.addAll(artifacts);
                    return val;
                });
            }
        }
        return models;
    }
}

