/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUrlRepository
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(SimpleUrlRepository.class);
    private String name;
    private URI uri;
    private String artifactId;
    private String modelName;
    private Metadata metadata;
    private boolean resolved;

    SimpleUrlRepository(String name, URI uri, String artifactId, String modelName) {
        this.name = name;
        this.uri = uri;
        this.artifactId = artifactId;
        this.modelName = modelName;
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.uri;
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        return this.getMetadata();
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public List<MRL> getResources() {
        try {
            Metadata m = this.getMetadata();
            if (m != null && !m.getArtifacts().isEmpty()) {
                MRL mrl = MRL.undefined(m.getGroupId(), m.getArtifactId());
                return Collections.singletonList(mrl);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to connect URL: " + this.uri, (Throwable)e);
        }
        return Collections.emptyList();
    }

    @Override
    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        logger.debug("Downloading artifact: {} ...", (Object)this.uri);
        try (InputStream is = this.uri.toURL().openStream();){
            this.save(is, tmp, baseUri, item, progress);
        }
    }

    private synchronized Metadata getMetadata() throws IOException {
        if (this.resolved) {
            return this.metadata;
        }
        Artifact artifact = new Artifact();
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        Artifact.Item item = new Artifact.Item();
        item.setUri(this.uri.getPath());
        item.setName("");
        item.setArtifact(artifact);
        item.setSize(this.getContentLength());
        files.put(this.artifactId, item);
        artifact.setFiles(files);
        artifact.setName(this.modelName);
        this.metadata = new Metadata.MatchAllMetadata();
        this.metadata.setApplication(Application.UNDEFINED);
        this.metadata.setGroupId("ai.djl.localmodelzoo");
        this.metadata.setArtifactId(this.artifactId);
        this.metadata.setArtifacts(Collections.singletonList(artifact));
        String hash = SimpleUrlRepository.md5hash(this.uri.toString());
        MRL mrl = MRL.model(Application.UNDEFINED, "ai.djl.localmodelzoo", hash);
        this.metadata.setRepositoryUri(mrl.toURI());
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getContentLength() throws IOException {
        String scheme = this.uri.getScheme();
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            HttpURLConnection conn = null;
            try {
                this.resolved = true;
                conn = (HttpURLConnection)this.uri.toURL().openConnection();
                conn.setRequestMethod("HEAD");
                int code = conn.getResponseCode();
                if (code != 200) {
                    logger.info("request error: " + code);
                    long l = -1L;
                    return l;
                }
                long l = conn.getContentLength();
                return l;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return -1L;
    }
}

