/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.index;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.index.dim.NDIndexBooleans;
import ai.djl.ndarray.index.dim.NDIndexElement;
import ai.djl.ndarray.index.full.NDIndexFullPick;
import ai.djl.ndarray.index.full.NDIndexFullSlice;
import java.util.List;
import java.util.Optional;

public abstract class NDArrayIndexer {
    public abstract NDArray get(NDArray var1, NDIndexFullPick var2);

    public abstract NDArray get(NDArray var1, NDIndexFullSlice var2);

    public NDArray get(NDArray array, NDIndex index) {
        if (index.getRank() == 0 && array.getShape().isScalar()) {
            return array.duplicate();
        }
        List<NDIndexElement> indices = index.getIndices();
        if (!indices.isEmpty() && indices.get(0) instanceof NDIndexBooleans) {
            if (indices.size() != 1) {
                throw new IllegalArgumentException("get() currently didn't support more that one boolean NDArray");
            }
            return array.booleanMask(((NDIndexBooleans)indices.get(0)).getIndex());
        }
        Optional<NDIndexFullPick> fullPick = NDIndexFullPick.fromIndex(index, array.getShape());
        if (fullPick.isPresent()) {
            return this.get(array, fullPick.get());
        }
        Optional<NDIndexFullSlice> fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape());
        if (fullSlice.isPresent()) {
            return this.get(array, fullSlice.get());
        }
        throw new UnsupportedOperationException("get() currently supports all, fixed, and slices indices");
    }

    public abstract void set(NDArray var1, NDIndexFullSlice var2, NDArray var3);

    public void set(NDArray array, NDIndexBooleans indices, NDArray value) {
        array.intern(NDArrays.where(indices.getIndex(), value, array));
    }

    public void set(NDArray array, NDIndex index, NDArray value) {
        NDIndexFullSlice fullSlice;
        List<NDIndexElement> indices = index.getIndices();
        if (!indices.isEmpty() && indices.get(0) instanceof NDIndexBooleans) {
            if (indices.size() != 1) {
                throw new IllegalArgumentException("get() currently didn't support more that one boolean NDArray");
            }
            this.set(array, (NDIndexBooleans)indices.get(0), value);
        }
        if ((fullSlice = (NDIndexFullSlice)NDIndexFullSlice.fromIndex(index, array.getShape()).orElse(null)) != null) {
            this.set(array, fullSlice, value);
            return;
        }
        throw new UnsupportedOperationException("set() currently supports all, fixed, and slices indices");
    }

    public abstract void set(NDArray var1, NDIndexFullSlice var2, Number var3);

    public void set(NDArray array, NDIndex index, Number value) {
        NDIndexFullSlice fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape()).orElse(null);
        if (fullSlice != null) {
            this.set(array, fullSlice, value);
            return;
        }
        List<NDIndexElement> indices = index.getIndices();
        if (!indices.isEmpty() && indices.get(0) instanceof NDIndexBooleans) {
            if (indices.size() != 1) {
                throw new IllegalArgumentException("set() currently didn't support more that one boolean NDArray");
            }
            this.set(array, (NDIndexBooleans)indices.get(0), array.getManager().create(value));
            return;
        }
        throw new UnsupportedOperationException("set() currently supports all, fixed, and slices indices");
    }

    public void setScalar(NDArray array, NDIndex index, Number value) {
        NDIndexFullSlice fullSlice = NDIndexFullSlice.fromIndex(index, array.getShape()).orElse(null);
        if (fullSlice != null) {
            if (fullSlice.getShape().size() != 1L) {
                throw new IllegalArgumentException("The provided index does not set a scalar");
            }
            this.set(array, index, value);
            return;
        }
        throw new UnsupportedOperationException("set() currently supports all, fixed, and slices indices");
    }
}

